// ======== ======== ======== ======== ======== ======== ======== ========
//
//			[Wwise.h] 							Auter : KENSUKE WATANABE
//												Data  : 2017/09/06
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/09/06
//
// ======== ======== ======== ======== ======== ======== ======== ========
//
// gI
// @ CreateNoListenerGameObj()ŃQ[IuWFNg쐬I
// A SetEvent()ŃCxgĐI
// B Stop()ŃCxg̒~I
//
// E Init(), Uninit(), Update() Manager.cppɏĉ
// E Xi[(m_pMainListener)́AvC[̈ʒuɍ킹Ėt[ݒ肵ĉ
// 
// -------- -------- -------- -------- -------- -------- -------- --------
#ifndef _WWISE_H_
#define _WWISE_H_

#include <windows.h>
#include <unordered_map>

// Releaseɒ`
#ifndef _DEBUG
#define AK_OPTIMIZED
#endif

// Wwise(TEhGW)gp邽߂ɕKv
#include <AK/SoundEngine/Common/AkSoundEngine.h>		// TEhGW
#include <AK/IBytes.h>

// #include <AK/Plugin/AkCompressorFXFactory.h>			// vOC

#include <AK/SoundEngine/Platforms/Windows/AkTypes.h>	// ^Cv

#include "Wwise_IDs.h"									// CxgID

using namespace AK;
using namespace AK::SoundEngine;

// ======== ======== ======== ======== ======== ======== ======== ========
// \
// -------- -------- -------- -------- -------- -------- -------- --------
// Q[IuWFNg
struct WWISE_GAMEOBJ
{
	D3DXVECTOR3 pos, rot;		// W, ]p
	D3DXVECTOR3 vel;			// x(hbv[ʂŕKvH)
};

// O錾
class CAkFilePackageLowLevelIOBlocking;

// ======== ======== ======== ======== ======== ======== ======== ========
// NX
// -------- -------- -------- -------- -------- -------- -------- --------
class CWwise
{
public:
	CWwise(){}
	~CWwise(){}

	void Init();	// 
	void Uninit();	// I
	void Update();	// XV

	// Q[IuWFNg̐
	WWISE_GAMEOBJ *CreateGameObj(D3DXVECTOR3 pos, D3DXVECTOR3 rot, char *name);				// Listenert
	WWISE_GAMEOBJ *CreateNoListenerGameObj(D3DXVECTOR3 pos, D3DXVECTOR3 rot, char *name);	// Listener
	void DeleteGameObj(std::string gameObjectName);

	// CxgM
	void MainListenerGameObjEvent(int eventID);				// CXi[(vC[)ɃCxg𑗐M
	void SetEvent(int eventID, D3DXVECTOR3 *loc = 0);		// [hW̎wʒuIDŃCxg𑗐M
	void SetEvent(char *name, D3DXVECTOR3 *loc = 0);		// [hW̎wʒuɖOŃCxg𑗐M
	void SetEvent(int eventID, std::string GameObjectName);	// wQ[IuWFNgIDŃCxg𑗐M
	void SetEvent(char *name, std::string GameObjectName);	// wQ[IuWFNgɖOŃCxg𑗐M

	// Q[IuWFNg̍Đ~
	void Stop(std::string name);
	void StopMainListener();

	// Cxg̏ԂύX
	void SetState(int stateGroup, int stateID);			// Xe[g̐ݒ
	void SetGameParam(int rtpcID, float value);			// Q[p[^[(RTPC)̐ݒ

	// }eA
	int GetMaterialId(char *name);						// O}eAID̎擾
//	void SetMaterial(void *gameObject, int materialid);	// Q[IuWFNgɃ}eAIDݒ

	// CXi[n
	void SetPos(const D3DXVECTOR3 &pos) { m_pMainListener->pos = pos; }		// W
	void SetRot(const D3DXVECTOR3 &rot) { m_pMainListener->rot = rot; }		// ]
	void SetVel(const D3DXVECTOR3 &vel) { m_pMainListener->vel = vel; }		// x

	// eQ[IuWFNg
	void SetPos(const std::string &name, const D3DXVECTOR3 &pos) {			// W
		if (m_umapGameObj.count(name) < 1) { assert(!"̖Os"); }
		m_umapGameObj[name]->pos = pos;
	}
	void SetRot(const std::string &name, const D3DXVECTOR3 &rot) {			// ]
		if (m_umapGameObj.count(name) < 1) { assert(!"̖Os"); }
		m_umapGameObj[name]->rot = rot;
	}
	void SetVel(const std::string &name, const D3DXVECTOR3 &vel) {			// x
		if (m_umapGameObj.count(name) < 1) { assert(!"̖Os"); }
		m_umapGameObj[name]->vel = vel;
	}

	// Lv`XgփG[bZ[W𑗂
	void PostMessage(char *szMessage);

	// D3DXVECTOR3AkVector̕ϊ
	static void VecToAkVector(const D3DXVECTOR3 &vec, AkVector &vector);

private:
	// Q[IuWFNg̓o^(ڂ͌ĂяoȂ)
	void registPtr(void *gameObject, char *name = NULL);
	void unregistPtr(void *gameObject);

	// ჌xI/O
	static CAkFilePackageLowLevelIOBlocking m_lowLevelIO;			

	// Q[IuWFNg
	std::unordered_map<std::string, WWISE_GAMEOBJ*> m_umapGameObj;	// Q[IuWFNg
	WWISE_GAMEOBJ *m_pMainListener;									// CXi[ւ̃|C^

	// _~[R[obN
	static void dummyCallback(AkCallbackType type, AkCallbackInfo* pCallbackInfo);
	static std::list<int> dummies;
	static CAkLock dummiesLock;

	/*	void soundvol(int vol);
	void musicvol(int vol);
	void voicevol(int vol);*/				
};

#endif
